import { Flex, Grid, Divider, Text, Heading } from "@chakra-ui/react";
import { BsFillCircleFill, BsStarFill } from "react-icons/bs";

export default function AccomodationInfo({ category, star, type }) {
  return (
    <Grid
      templateColumns="repeat(2, 1fr)"
      boxShadow="custom"
      p="5"
      rounded="md"
      bg="white"
      gap={{
        base: 5,
        lg: 2,
        xl: 5,
      }}
      h={{
        base: "auto",
        sm: 32,
      }}
    >
      <Flex
        px={{
          base: 5,
          lg: 2,
          xl: 5,
        }}
        py={{
          base: 5,
          lg: 2,
          xl: 5,
        }}
      >
        <Heading as="h6" color="black" fontSize="30px">
          {type}
        </Heading>
      </Flex>
      <Flex
        gap={{
          base: 6,
          lg: 4,
          xl: 6,
        }}
      >
        <Divider orientation="vertical" h="80px" borderColor="sage.900" />
        <Flex
          direction="column"
          gap={2}
          sx={{
            svg: {
              height: "1.5em",
              width: "1.5em",
              fill: "orangePeel.900",
            },
          }}
        >
          <Flex align="center" gap={3}>
            <BsFillCircleFill />
            <Text
              as="span"
              fontSize={{
                lg: "18px",
                xl: "24px",
              }}
            >
              {category === "gold" ? "Gold" : "Other"}
            </Text>
          </Flex>
          <Flex align="center" gap={3}>
            <BsStarFill />
            <Text
              as="span"
              fontSize={{
                lg: "18px",
                xl: "24px",
              }}
            >
              {star} Star
            </Text>
          </Flex>
        </Flex>
      </Flex>
    </Grid>
  );
}
