import { Box, List, ListItem, Flex, Text, ListIcon } from "@chakra-ui/react";
import { KtHeading } from "@/app/_components";
import { BsFillCircleFill } from "react-icons/bs";

export default function ItineraryList({ heading, items }) {
  return (
    <Box pt={8}>
      <Box pb={8}>
        <KtHeading as="h6">{heading}</KtHeading>
      </Box>
      <List
        pos="relative"
        ml={{
          base: 0,
          md: 28,
        }}
        borderLeftWidth="1px"
        borderLeftColor="sage.900"
      >
        {items.map(({ id, day, itinerary: { heading, description } }) => (
          <ListItem
            key={id}
            _notLast={{
              pb: 6,
            }}
            ml={6}
          >
            <ListIcon
              as={BsFillCircleFill}
              color="sage.900"
              pos="absolute"
              left={-2}
            />
            <Text
              fontSize="20px"
              color="black"
              fontWeight="semibold"
              pos={{
                base: "relative",
                md: "absolute"
              }}
              left={{
                base: 0,
                md: -28,
              }}
            >
              {day}
            </Text>
            <Flex direction="column" gap={6}>
              <Text fontWeight="semibold" fontSize="20px" color="black">
                {heading}
              </Text>
              <Text color="#707070" fontWeight="medium">
                {description}
              </Text>
            </Flex>
          </ListItem>
        ))}
      </List>
    </Box>
  );
}
