import { useState, useEffect } from "react";
import { shape, string } from "prop-types";

import { ReactSVG } from "react-svg";
import { Flex, Box, Text } from "@chakra-ui/react";
import { KtHeading } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";
import Link from "next/link";

// Function to replace &bull; with <li> tags and wrap in <ul> tag
/* const replaceBulletPoints = (text) => {
  const replacedText = text
  .replace(/&bull;/g, "<li>")
  .replace(/\r\n/g, "<br>")
  .replace(/<li>/, "<ul><li>");
  return `${replacedText}</li></ul>`;
  
}; */



export default function HowToReach({ how_to_reach }) {

  const [replacedText, setReplacedText] = useState({});

  useEffect(() => {
    const newReplacedText = {};
    Object.keys(how_to_reach).forEach((htr) => {
      const text = how_to_reach[htr]["reach_by"];
      const replacedText = text
        .replace(/&bull;/g, "<li>")
        .replace(/\r\n/g, "<br>")
        .replace(/<li>/, "<ul><li>");
      newReplacedText[htr] = `${replacedText}</li></ul>`;
    });
    setReplacedText(newReplacedText);
  }, [how_to_reach]);
  return (
    <>
      <KtHeading as="h6" color="black">
        How To Reach
      </KtHeading>
      <Flex
        direction={{
          base: "column",
          md: "row",
        }}
        py={10}
        gap={4}
      >
        {Object.keys(how_to_reach).map((htr) => (
          <Box
            key={htr}
            maxW={{
              base: "full",
              md: "33.33%",
            }}
          >
            <Flex
              alignItems="center"
              direction={{
                base: "row",
              }}
              gap={2}
            >
              {htr === "flight" && <ReactSVG alt="Flight" title="Flight" src="/icons/plane.svg" />}
              {htr === "bus" && <ReactSVG alt="Bus" title="Bus"  src="/icons/bus.svg" />}
              {htr === "train" && <ReactSVG alt="Train" title="Train" src="/icons/train.svg" />}
              <KtHeading as="h6" color="black">
                {how_to_reach[htr]["label"]}
              </KtHeading>
            </Flex>
            <Text
              as="p"
              pt={3}
              pb={5}
              fontSize={appTextFontSize}
              dangerouslySetInnerHTML={{ __html: replacedText[htr] }}
            />
          {/*   <Text as="p" pt={3} pb={5} fontSize={appTextFontSize} >
            {how_to_reach[htr]["reach_by"]}
            </Text> */}
            <Flex gap={3}>
              {/* <Text as="span" color="orangePeel.900" fontSize={appTextFontSize}>
                <Link href={how_to_reach[htr]["booking"]} title="Book now" >Book now</Link>
              </Text> */}
              {how_to_reach[htr]["booking"] && ( // Check if route_map is not empty or null
                <Text as="span" color="orangePeel.900" fontSize={appTextFontSize}>
                  <Link href={how_to_reach[htr]["booking"]} title="Book now" target="_blank" >Book now</Link>
                </Text>
              )}
              {how_to_reach[htr]["route_map"] && ( // Check if route_map is not empty or null
                <Text as="span" color="gray.400" fontSize={appTextFontSize}>
                  <Link href={how_to_reach[htr]["route_map"]} title="Route map" target="_blank">Route map</Link>
                </Text>
              )}
            </Flex>
          </Box>
        ))}
      </Flex>
    </>
  );
}

HowToReach.propTypes = {
  how_to_reach: shape({
    fligt: shape({
      label: string,
      reach_by: string,
    }),
    bus: shape({
      label: string,
      reach_by: string,
    }),
    train: shape({
      label: string,
      reach_by: string,
    }),
  }),
};
