import { string } from "prop-types";

import ReactMarkdown from "react-markdown";
import rehypeRaw from "rehype-raw";

import { Stack,
  Card,
  CardHeader,
  CardBody,
  Heading,Text,Box } from "@chakra-ui/react";
import { AppMarkDown } from "@/app/_components";

export default function ArticleMarkDown({ content,disclaimer }) {
  return (
    <>
    <Box
      py={{
        base: 4,
        md: 10,
      }}
    >
      <AppMarkDown content={content} />
    </Box>
    {disclaimer && (
      <Stack spacing='4' mb='5'>      
        <Card key="disclaimer" variant="filled">
          <CardHeader>
            <Heading size='md'> Disclaimer</Heading>
          </CardHeader>
          <CardBody>
            <Text>{disclaimer}</Text>
          </CardBody>
        </Card>    
      </Stack>
       )}
      </>
  );
}

ArticleMarkDown.propTypes = {
  content: string.isRequired,
};
