import { string } from "prop-types";

import { Flex, Box, Text, IconButton } from "@chakra-ui/react";
import { BsShare, BsHeart } from "react-icons/bs";
import { KtHeading } from "@/app/_components";
export default function ArticleHeading({ heading, published_at }) {
  return (
    <Flex
      direction={{
        base: "column",
        md: "row",
      }}
      gap={{
        base: 4,
        md: 0,
      }}
      align={{
        base: "flex-start",
        md: "center",
      }}
      justify="space-between"
    >
      <Box
        order={{
          base: 2,
          md: 1,
        }}
        maxW="2xl"
      >
        <Flex direction="column" gap={!!published_at ? 4 : 0}>
          <KtHeading as="h5" color="black">
            {heading}
          </KtHeading>
          {published_at && (
            <Text color="orangePeel.900" fontWeight="semibold">Published on : { published_at}</Text>
          )}
        </Flex>
      </Box>
      <Flex
        order={{
          base: 1,
          md: 2,
        }}
        gap={{
          base: 2,
          md: 5,
        }}
        sx={{
          "svg path": {
            fill: "orangePeel.900",
          },
        }}
      >
        {/* <IconButton size="lg" icon={<BsShare />} isRound />
        <IconButton size="lg" icon={<BsHeart />} isRound /> */}
      </Flex>
    </Flex>
  );
}

ArticleHeading.propTypes = {
  heading: string.isRequired,
};
