import { oneOf } from "prop-types";
import { motion } from "framer-motion";

const _gVariant = (direction) => {
  const _xCordinate = direction === "ltr" ? 3.599 : -2.555;
  return {
    hover: {
      x: [0, _xCordinate],
    },
  };
};

const _lineVariant = {
  hover: {
    x: [-7.3],
    y: [12],
    opacity: 1,
    stroke: "#ff9d00",
  },
};

export const SvgArrow = ({
  variant = "small",
  direction = "ltr",
  color = "white",
}) => {
  const _svgWidthHeight = variant === "small" ? "0.5em" : "0.7em";
  const _gTx = `translate(${direction === "ltr" ? `0 0` : `24.336 24.336`})`;
  const _pathFillColor = color === "white" ? "#fff" : "#000";

  return (
    <motion.svg
      width={_svgWidthHeight}
      height={_svgWidthHeight}
      viewBox="0 0 24.336 24.336"
      initial={false}
    >
      <motion.g
        rotate={direction === "rtl" ? 180 : 0}
        transform={`${_gTx} rotate(${direction === "rtl" ? 180 : 0})`}
        initial={{
          x: [0, 0],
          rotate: direction === "ltr" ? 0 : 180,
        }}
        variants={_gVariant(direction)}
      >
        <motion.path
          d="M5.879,13.766H15.5a2.2,2.2,0,0,1,.384.043,1.79,1.79,0,0,1,1.207,2.339,1.753,1.753,0,0,1-1.4,1.052,1.433,1.433,0,0,1-.193.01H1.722l-.1,0a1.412,1.412,0,0,1-.191-.022A1.761,1.761,0,0,1,.01,15.681,1.785,1.785,0,0,1,0,15.488V1.711A1.784,1.784,0,0,1,2.382.12a1.761,1.761,0,0,1,1.052,1.4,1.809,1.809,0,0,1,.01.193l-.25,12.042c-.081-.052-1.131,0,2.685.012Z"
          transform="translate(8 24.336) rotate(-135)"
          fill={_pathFillColor}
        />
        <motion.line
          x1="25"
          variants={_lineVariant}
          fill="none"
          opacity={0}
          strokeLinecap="round"
          strokeWidth="3"
        />
      </motion.g>
    </motion.svg>
  );
};

SvgArrow.propTypes = {
  variant: oneOf(["large", "small"]),
  direction: oneOf(["ltr", "rtl"]),
  color: oneOf(["black", "white"]),
};
