"use client";

import { useRef } from "react";
import { useInView } from "framer-motion";
import { string, bool } from "prop-types";
import { Box, Text } from "@chakra-ui/react";

import KtContainer from "../KtContainer";
import KtHeading from "../KtHeading";

export default function SectionHeading({
  heading,
  description,
  slider = false,
}) {
  const ref = useRef(null);
  const isInView = useInView(ref, { once: true });

  const headingWrapperSection = {
    ...(slider && {
      pb: {
        base: heading ? 2 : 0,
        "2xl": heading ? 4 : 0,
      },
    }),
    ...(!slider && {
      pb: {
        base: heading ? 4 : 0,
      },
    }),
    ...(typeof heading === "undefined" && typeof description === "string" && {
      py: {
        base: "5"
      }
    })
  };

  return (
    <KtContainer maxW="container.xl">
      <Box
        textAlign="center"
        ref={ref}
        overflow="hidden"
        w={{
          base: "full",
          lg: !heading ? "2xl" : "full",
        }}
        {...(!heading && { mx: "auto" })}
        {...headingWrapperSection}
      >
        <Box
          as="div"
          style={{
            transform: isInView ? "none" : "translateY(-150px)",
            opacity: isInView ? 1 : 0,
            transition: "all 0.9s cubic-bezier(0.17, 0.55, 0.55, 1) 0.5s",
          }}
        >
          {heading && (
            <KtHeading
              as="h2"
              mb={{
                base: 0,
                lg: 5,
              }}
              fontWeight="500"
            >
              {heading}
            </KtHeading>
          )}

          {description && (
            <Box maxW="5xl" mx="auto" pb={4}>
              <Text
                as="p"
                textStyle="p"
                fontSize={{
                  base: "18px",
                  sm: "20px",
                  md: "22px",
                  lg: "24px",
                }}
              >
                {description}
              </Text>
            </Box>
          )}
        </Box>
      </Box>
    </KtContainer>
  );
}

SectionHeading.propTypes = {
  heading: string,
  description: string,
  slider: bool,
};
