import { motion } from "framer-motion";

const motionGlobalVariants = {
  initial: {
    x: [0, 0]
  },
  hover: {
    x: [0, 3.599]
  }
};

const motionLineVariant = {
  initial: {
    x: [11.5],
    y: [7.132]
  },
  hover: {
    x1: 14.255,
    x: [-2.342],
    y: [7.132],
    opacity: 1,
    stroke: "#ff9d00",
  }
};

function MotionSvg() {
  return (
    <motion.svg width="1em" height="1em" whileHover="hover" initial={false}>
      <motion.g variants={motionGlobalVariants}>
        <motion.path
          d="M3.414,7.994H9a1.278,1.278,0,0,1,.223.025,1.04,1.04,0,0,1,.7,1.358,1.018,1.018,0,0,1-.812.611A.832.832,0,0,1,9,9.994H.944A.82.82,0,0,1,.833,9.98a1.023,1.023,0,0,1-.827-.874A1.037,1.037,0,0,1,0,8.994v-8A1.036,1.036,0,0,1,1.383.07a1.023,1.023,0,0,1,.611.812A1.051,1.051,0,0,1,2,.994L1.855,7.987c-.047-.03-.657,0,1.559.007Z"
          transform="translate(7.065 14.132) rotate(-135)"
          fill="#434343"
        />
        <motion.line
          x1={14.255}
          stroke="#434343"
          strokeLinecap="round"
          strokeWidth="2.5"
          opacity={0}
          variants={motionLineVariant}
        />
      </motion.g>
    </motion.svg>
  );
}

export default MotionSvg;
