import { oneOf, node } from "prop-types";
import { Heading } from "@chakra-ui/react";
import { pxToRem } from "@/app/_utils";

export default function KtHeading({ children, as = "h2", color = "black", ...rest }) {
  const fontSize = {
    h1: [],
    h2: [
      pxToRem(42),
      pxToRem(52),
      pxToRem(60),
    ],
    h3: [
      pxToRem(34),
      pxToRem(42),
      pxToRem(50),
    ],
    h4: [
      pxToRem(32),
      pxToRem(36),
      pxToRem(40),
    ],
    h5: [
      pxToRem(24),
      pxToRem(30),
      pxToRem(32),
    ],
    h6: [
      pxToRem(18),
      pxToRem(22),
      pxToRem(26),
    ],
  };

  return (
    <Heading as={as} fontWeight="normal" color={color} fontSize={fontSize[as]} {...rest}>
      {children}
    </Heading>
  );
}

KtHeading.propTypes = {
  children: node.isRequired,
  color: oneOf(["black", "white", "orangePeel.900", "sage.900", "russian.900"]),
  as: oneOf(["h1", "h2", "h3", "h4", "h5", "h6"]),
};
