import { node } from "prop-types";
import { Icon } from "@chakra-ui/react";
import {
  BsPlay,
  BsVolumeUp,
  BsVolumeMute,
  BsChevronLeft,
  BsChevronRight,
  BsPause,
} from "react-icons/bs";

function AppIcon({ IconComponent }) {
  return (
    <Icon
      as={IconComponent}
      color="white"
      fontSize={{
        base: 22,
        lg: 30,
      }}
    />
  );
}

export const PlayIcon = () => <AppIcon IconComponent={BsPlay} />;
export const PauseIcon = () => <AppIcon IconComponent={BsPause} />;
export const VolumeIcon = () => <AppIcon IconComponent={BsVolumeUp} />;
export const VolumeMuteIcon = () => <AppIcon IconComponent={BsVolumeMute} />;
export const LeftIcon = () => <AppIcon IconComponent={BsChevronLeft} />;
export const RightIcon = () => <AppIcon IconComponent={BsChevronRight} />;
