import { bool, node, func } from "prop-types";
import { Flex } from "@chakra-ui/react";

export default function IconWrapper({ children, onClick, border = true }) {
  const borderProp = border
    ? {
        border: "1px",
        borderColor: "white",
        borderRadius: "full",
        transition: "borderColor .5s ease",
        _hover: {
          borderColor: "orangePeel.900",
        },
      }
    : {};

  return (
    <Flex
      justify="center"
      align="center"
      as="div"
      cursor="pointer"
      w={42}
      h={42}
      {...borderProp}
      onClick={onClick}
    >
      {children}
    </Flex>
  );
}

IconWrapper.propTypes = {
  children: node.isRequired,
  border: bool,
  onClick: func
};
