import dynamic from "next/dynamic";
const Select = dynamic(
  () => import("react-select").then((mod) => mod.default),
  { ssr: false }
);

const styles = (customWidth, bordered) => ({
  control: (baseStyles, state) => ({
    ...baseStyles,
    backgroundColor: "transparent",
    ...(!bordered && {
      borderColor: "transparent",
      borderBottomColor: state.isFocused ? "#9CA777" : "#9CA777",
      borderRadius: 0,
      ":hover": {
        borderColor: "transparent",
        borderBottomColor: "#9CA777",
      },
      boxShadow: state.isFocused ? "0px 1px 0px 0px #9CA777" : "none",
    }),
    ...(bordered && {
      borderColor: "#FF9D00",
      borderRadius: "50px",
      ":hover": {
        borderColor: "#FF9D00",
      },
      boxShadow: state.isFocused ? "0px 0px 0px 1px #FF9D00" : "none",
    }),
    transition: "all 0.2s linear",
  }),
  placeholder: (baseStyles) => ({
    ...baseStyles,
    color: "#939395",
  }),
  menu: (baseStyles) => ({
    ...baseStyles,
    ...(customWidth && {
      width: "500px",
    }),
    boxShadow: "0px 0px 15px 0px rgba(0, 0, 0, 0.1)",
    borderRadius: "10px",
  }),
  menuList: (baseStyles) => ({
    ...baseStyles,
    display: "flex",
    flexFlow: "row wrap",
    gap: "12px",
    paddingRight: "1em",
    paddingLeft: "1em",
    paddingTop: "1.5em",
    paddingBottom: "1.5em",
  }),
  option: (baseStyles, state) => ({
    ...baseStyles,
    border: "1px solid #FF9D00",
    borderRadius: "50px",
    color: state.isFocused ? "#FFF" : "#232426",
    fontSize: "16px",
    width: "auto",
    padding: "4px 20px",
    backgroundColor: state.isFocused ? "#FF9D00" : "#FFF",
    transition: "all 0.5s linear",
  }),
  multiValue: (baseStyles) => ({
    ...baseStyles,
    background: "transparent",
    border: "1px solid #FF9D00",
    borderRadius: "50px",
  }),
  multiValueLabel: (baseStyles) => ({
    ...baseStyles,
    paddingLeft: "12px",
  }),
  multiValueRemove: (baseStyles) => ({
    ...baseStyles,
    paddingRight: "12px",
    ":hover": {
      background: "transparent",
    },
  }),
});

export default function AppWhMultiSelect({
  placeholder,
  options,
  isSearchable = false,
  isClearable = false,
  isMulti = false,
  customWidth = false,
  bordered = false,
  handleDestinationChange,
  handleCategoryChange,
  handleOpDestinationChange,
  hfn,
  nm
}) {
  return (
    <Select
    //closeMenuOnSelect={false}
      id={nm}
      name={nm}
      defaultValue=""
      options={options}
      className="app-select-container"
      classNamePrefix="app-select"
      placeholder={placeholder}
      styles={styles(customWidth, bordered)}
      isSearchable={isSearchable}
      isClearable={isClearable}
      isMulti={isMulti}
       
      //onChange={handleDestinationChange(123)}
      onChange={(selectedOptions) => {
        if (hfn === "location") {
          const selectedDestValues = isMulti
            ? selectedOptions.map((option) => option.value)
            : selectedOptions ? [selectedOptions.value] : [];
          handleDestinationChange(selectedDestValues);
        } else if (hfn === "cat") {
          const selectedCatValues = isMulti
            ? selectedOptions.map((option) => option.value)
            : selectedOptions ? [selectedOptions.value] : [];
          handleCategoryChange(selectedCatValues);
        } else if (hfn === "op") {
          const selectedOpValues = isMulti
            ? selectedOptions.map((option) => option.value)
            : selectedOptions ? [selectedOptions.value] : [];
            handleOpDestinationChange(selectedOpValues);
        }
      }}
    />
  );
}
