import { forwardRef } from "react";
import { node } from "prop-types";
import {
  Tabs,
  TabList,
  Tab,
  TabPanels,
  TabPanel,
  TabIndicator,
} from "@chakra-ui/react";

export default function AppTab({ children, ...restTabStyleProps }) {
  return (
    <Tabs variant="unstyled" pos="relative" {...restTabStyleProps}>
      {children}
    </Tabs>
  );
}

AppTab.propTypes = {
  children: node.isRequired,
};

export const AppTabIndicator = (props) => {
  return (
    <TabIndicator
      mt="-5px"
      height="4px"
      bg="orangePeel.900"
      borderRadius="1px"
      {...props}
    />
  );
};

export const AppTabList = forwardRef(
  ({ children, ...restTabListProps }, ref) => {
    return (
      <TabList ref={ref} {...restTabListProps}>
        {children}
      </TabList>
    );
  }
);

AppTabList.propTypes = {
  children: node.isRequired,
};

AppTabList.displayName = "AppTabList";

export const AppTabNavItem = ({ children, ...restTabNavProps }) => {
  return <Tab {...restTabNavProps}>{children}</Tab>;
};

AppTabNavItem.propTypes = {
  children: node.isRequired,
};

export const AppTabPanelParent = ({ children, ...restTabPanelParentProps }) => {
  return <TabPanels {...restTabPanelParentProps}>{children}</TabPanels>;
};

AppTabPanelParent.propTypes = {
  children: node.isRequired,
};

export const AppTabPanel = ({ children, ...restTabPanelProps }) => {
  return <TabPanel {...restTabPanelProps}>{children}</TabPanel>;
};

AppTabPanel.propTypes = {
  children: node.isRequired,
};
