import { useRef, useState, useEffect } from "react";

// Setting The Tab Style Based on the Ref and
// Scroll Width
export const useTabStyle = () => {
  const tabListRef = useRef(null);
  const [tablistStyleProps, setTabListStyleProps] = useState({
    display: "grid",
    gridAutoFlow: "column",
    overflowX: "auto",
    scrollSnapType: "x mandatory",
    scrollPadding: "1rem",
  });

  useEffect(() => {
    if (tabListRef.current.scrollWidth > tabListRef.current.clientWidth) {
      setTabListStyleProps((prev) => ({
        ...prev,
        paddingBottom: "10px",
        placeContent: "flex-start",
      }));
    } else {
      setTabListStyleProps((prev) => ({
        ...prev,
        paddingBottom: 0,
        placeContent: "center",
      }));
    }
  }, [tabListRef]);

  return [tabListRef, tablistStyleProps];
};
