import { node, bool } from "prop-types";
import { Box } from "@chakra-ui/react";

import { pxToRem } from "@/app/_utils";

function AppSection({
  children,
  explore = false,
  sectionHeading = true,
  ...sectionProps
  
}) {
  
  const sectionStyleProps = {
    pos: "relative",
    pt: {
      base: sectionHeading ? pxToRem(50) : 0,
      md: pxToRem(60),
    },
    pb: {
      base: pxToRem(90 / 4 + (explore ? 36 : 0)),
      xl: pxToRem(90 / 2),
      "2xl": pxToRem(90),
    },
  };

  /*console.log("test 4");
  console.log(sectionProps);
  console.log("test 5");*/
  return (
    <Box as="section" {...sectionStyleProps} {...sectionProps} >
      {children}
    </Box>
  );
}

AppSection.propTypes = {
  children: node.isRequired,
  explore: bool,
  sectionHeading: bool,
};

export default AppSection;
