import { motion } from "framer-motion";
import { useState } from "react";
import {
  Box,
  Button,
  Input,
  Flex,
} from "@chakra-ui/react";
import { SvgArrow } from "@/app/_components/Svg";

export default function AppSearchInput({ btnTitle = "Go", serachInputAction }) {
  const [searchValue, setSearchValue] = useState("");

  function handleKeyPress(e) {
    if (e.key === 'Enter') {
      serachInputAction(searchValue);
    }
  }

  return (
    <Box mb={8}>
      <Flex alignItems="center">
        <Input
          placeholder="Search"
          variant="flushed"
          focusBorderColor="orangePeel.900"
          bg="rgba(255, 255, 255, 0.8)" // Set semi-transparent background
          color="black" // Set text color for better readability
          _placeholder={{ color: 'gray.500' }} // Style placeholder text color
          value={searchValue}
          onChange={(e) => setSearchValue(e.target.value)}
          onKeyPress={handleKeyPress}
          id="searchKeyword"
          fontSize="24px" // Adjust the font size here
          borderRadius="md" // Set border radius to medium size
          p={2} // Optional: Add padding for better spacing
          flex="1" // Allow input to take up remaining space
          mr={4} // Add margin to the right of the input
        />
        <Button
          variant="outline"
          borderRadius="full"
          as={motion.button}
          size="md"
          fontSize={{
            base: "14px",
            md: "16px",
            lg: "20px",
          }}
          borderColor="black"
          whileHover="hover"
          initial={false}
          _hover={{
            color: "orangePeel.900",
            "svg path": {
              fill: "orangePeel.900",
            },
          }}
          onClick={() => serachInputAction(searchValue)}
        >
          {btnTitle}&nbsp;
          <SvgArrow color="black" />
        </Button>
      </Flex>
    </Box>
  );
}
