

import { Box } from "@chakra-ui/react";
import ReactPaginate from "react-paginate";

import { paginationStyles } from "./_styles";


export default function AppPagination({ pageCount, handlePageClick,currentPage }) {
  return (
    <Box
      pt={{
        base: 8,
        md: 12,
      }}
      pb={{
        base: 8,
        md: 0,
      }}
      overflowX="auto"
      scrollPadding={8}
      sx={paginationStyles}
    >
      <ReactPaginate
        breakLabel="..."
        containerClassName="pagination"
        nextLabel=">"
        breakClassName="pagination__break"
        breakLinkClassName="pagination__break__link"
        onPageChange={handlePageClick}
        pageRangeDisplayed={2}
        marginPagesDisplayed={1}
        pageCount={pageCount}
        previousLabel="<"
        initialPage={currentPage - 1}
        />
    </Box>
  );
}
