
"use client";
import { useParams } from "next/navigation";
import { useEffect, useRef } from "react";
import dynamic from "next/dynamic";
const Select = dynamic(
  () => import("react-select").then((mod) => mod.default),
  { ssr: false }
);

const styles = (customWidth, bordered) => ({
  control: (baseStyles, state) => ({
    ...baseStyles,
    backgroundColor: "transparent",
    ...(!bordered && {
      borderColor: "transparent",
      borderBottomColor: state.isFocused ? "#9CA777" : "#9CA777",
      borderRadius: 0,
      ":hover": {
        borderColor: "transparent",
        borderBottomColor: "#9CA777",
      },
      boxShadow: state.isFocused ? "0px 1px 0px 0px #9CA777" : "none",
    }),
    ...(bordered && {
      borderColor: "#FF9D00",
      borderRadius: "50px",
      ":hover": {
        borderColor: "#FF9D00",
      },
      boxShadow: state.isFocused ? "0px 0px 0px 1px #FF9D00" : "none",
    }),
    transition: "all 0.2s linear",
  }),
  placeholder: (baseStyles) => ({
    ...baseStyles,
    color: "#939395",
  }),
  menu: (baseStyles) => ({
    ...baseStyles,
    ...(customWidth && {
      width: "500px",
    }),
    boxShadow: "0px 0px 15px 0px rgba(0, 0, 0, 0.1)",
    borderRadius: "10px",
  }),
  menuList: (baseStyles) => ({
    ...baseStyles,
    display: "flex",
    flexFlow: "row wrap",
    gap: "12px",
    paddingRight: "1em",
    paddingLeft: "1em",
    paddingTop: "1.5em",
    paddingBottom: "1.5em",
  }),
  option: (baseStyles, state) => ({
    ...baseStyles,
    border: "1px solid #FF9D00",
    borderRadius: "50px",
    color: state.isFocused ? "#FFF" : "#232426",
    fontSize: "16px",
    width: "auto",
    padding: "4px 20px",
    backgroundColor: state.isFocused ? "#FF9D00" : "#FFF",
    transition: "all 0.5s linear",
  }),
  multiValue: (baseStyles) => ({
    ...baseStyles,
    background: "transparent",
    border: "1px solid #FF9D00",
    borderRadius: "50px",
  }),
  multiValueLabel: (baseStyles) => ({
    ...baseStyles,
    paddingLeft: "12px",
  }),
  multiValueRemove: (baseStyles) => ({
    ...baseStyles,
    paddingRight: "12px",
    ":hover": {
      background: "transparent",
    },
  }),
});

export default function AppMultiSelect({
  label,
  placeholder,
  options,
  isSearchable = false,
  isClearable = false,
  isMulti = false,
  customWidth = false,
  bordered = false,
  handlePrimaryFilterChange,
  selectedValuesVariable,
  primary_filters,
  secondary_filter,
}) {

  // Check if selectedValuesVariable is defined and has the required property
  const selectedValuesToPreselect = selectedValuesVariable
    ? selectedValuesVariable[label.toLowerCase().replace(/\s/g, "-")] || []
    : [];

  // Filter options to get preselected options
  const preselectedOptions = options.filter(option => selectedValuesToPreselect.includes(option.value));
 
  return (
    <Select
    closeMenuOnSelect={false}
    defaultValue={preselectedOptions}
    options={options}
    value={preselectedOptions}
    className="app-select-container"
    classNamePrefix="app-select"
    placeholder={placeholder}
    styles={styles(customWidth, bordered)}
    isSearchable={isSearchable}
    isClearable={isClearable}
    isMulti={isMulti}
    onChange={(selectedOptions) => {
      if (primary_filters && primary_filters.length > 0) {
        const selectedValueschosen = {};
        
        primary_filters.forEach(({ label }) => {
          const element = document.getElementById(
            label.toLowerCase().replace(/\s/g, "-")
          );
  
          if (element !== null) {
            const filterValue = element.value;
  
            if (filterValue !== null && filterValue !== "") {
              selectedValueschosen[
                label.toLowerCase().replace(/\s/g, "-")
              ] = filterValue;
            }
          }
        });
  
        const selectedValues = isMulti
          ? selectedOptions.map((option) => option.value)
          : selectedOptions ? [selectedOptions.value] : [];
  
        handlePrimaryFilterChange({
          ...selectedValueschosen,
          [placeholder.toLowerCase().replace(/\s/g, "-")]: selectedValues,
        });
      }
    }}
  />
  );
}
