import {
  Modal,
  ModalOverlay,
  ModalContent,
  ModalBody,
  ModalCloseButton,
  ModalHeader,
  Box,
} from "@chakra-ui/react";

export default function AppModal({
  isOpen,
  size = "md", // Default size
  hasOverLay = true,
  hasHeader = false,
  renderHeader,
  onClose,
  children,
  modalProps = {},
  modalBodyProps = {},
  modalHeaderProps = {},
  closeBtnProps = {},
}) {
  return (
    <Modal
      closeOnOverlayClick={false}
      onClose={onClose}
      isOpen={isOpen}
      size={size} // Directly set size
      isCentered
      scrollBehavior="inside"
    >
      {hasOverLay && (
        <ModalOverlay
          bg="blackAlpha.300"
          backdropFilter="blur(10px) hue-rotate(90deg)"
        />
      )}
      <ModalContent {...modalProps} bg="rgba(255, 255, 255, 0.8)"> {/* Set semi-transparent background */}
        {hasHeader && (
          <ModalHeader {...modalHeaderProps}>
            {renderHeader ? renderHeader() : "Header"}
          </ModalHeader>
        )}
        <ModalCloseButton {...closeBtnProps} />
        <ModalBody {...modalBodyProps}>{children}</ModalBody>
      </ModalContent>
    </Modal>
  );
}
