import { string } from "prop-types";
import Link from "next/link";
import ReactMarkdown from "react-markdown";
import rehypeRaw from "rehype-raw";
import {
  Text,
  List,
  ListItem,
  ListIcon,
  Link as ChakraLink,
} from "@chakra-ui/react";
import { BsMoon } from "react-icons/bs";
import { KtHeading } from "@/app/_components";
import { appTextFontSize } from "@/app/_components/_styles";

export default function AppMarkDown({ content }) {
  return (
    <ReactMarkdown
  components={{
    a: ({ children, ...restProps }) => {
      const { properties } = restProps.node;
      const isSameOrigin = properties.href.includes(process.env.baseUrl);

      // Ensure children[0] is a string
      let lwrchild = typeof children[0] === 'string' ? children[0].toLowerCase() : '';

      if (!isSameOrigin) {
        return (
          <ChakraLink
            href={properties.href}
            {...(properties?.target && {
              target: properties.target,
            })}
            color="orangePeel.900"
            style={lwrchild === children[0] ? { textTransform: 'lowercase' } : {}}
          >
            {children}
          </ChakraLink>
        );
      } else {
        const urlParts = properties.href.split("/").slice(3).join("/");
        return (
          <Link href={`/${urlParts}`} legacyBehavior passHref>
            <ChakraLink color="orangePeel.900">{children}</ChakraLink>
          </Link>
        );
      }
    },
    p: ({ children }) => <Text fontSize={appTextFontSize}>{children}</Text>,
    h5: ({ children }) => (
      <KtHeading as="h5" color="black">
        {children}
      </KtHeading>
    ),
    ul: ({ children }) => <List spacing={3}>{children}</List>,
    li: ({ children }) => (
      <ListItem fontSize={appTextFontSize}>
        <ListIcon as={BsMoon} color="orangePeel.900" />
        {children}
      </ListItem>
    ),
  }}
  rehypePlugins={[rehypeRaw]}
  children={content}
/>

  );
}

AppMarkDown.propTypes = {
  content: string.isRequired,
};
