import { string } from "prop-types";

import { IconButton } from "@chakra-ui/react";
import { BsSend } from "react-icons/bs";

export default function AppLocationButton({ location_url }) {
  return (
    <IconButton
      bg="white"
      borderColor="black"
      borderWidth="thin"
      _hover={{
        bg: "white",
      }}
      sx={{
        "svg path": {
          color: "orangePeel.900",
        },
      }}
      as="a"
      target="_blank"
      href={location_url}
      rel="noopener noreferrer"
      icon={<BsSend />}
      size="md"
      isRound
    />
  );
}

AppLocationButton.propTypes = {
  location_url: string.isRequired,
};
