import Link from "next/link";
import { Link as ChakraLink } from "@chakra-ui/react";

import { motion } from "framer-motion";

import { SvgArrow } from "../Svg";

const RootLink = ({ children, href }) => {
  return (
    <Link href={href} passHref legacyBehavior>
      {children}
    </Link>
  );
};

const LinkChildrenWithArrow = ({ children, arrowDir, color }) => {
  return (
    <>
      {arrowDir === "rtl" && <SvgArrow direction={arrowDir} color={color} />}
      {children}
      {arrowDir === "ltr" && <SvgArrow direction={arrowDir} color={color} />}
    </>
  );
};

export default function AppLink({
  variant = "default",
  color = "white",
  arrowDir = "ltr",
  arrow = false,
  animate = false,
  title,
  type,
  parent,
  slug = "",
  children,
  boxSize=false,
  ...restLinkStyles

}) {
  let prnt;
  type === "internal"
      ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
      : type === "internal-other"
      ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
      : prnt=parent 
  const linkUrl = (prnt ?? "").concat(slug ?? "");

  const innerLinkProps = {
    title,
    ...((type === "internal-other" || type === "external" || type === "internal") && {
      href: linkUrl,
    }),
    ...((type === "external" || type === "internal-other" )&& {
      target: "_blank",
      rel: "noopener noreferrer",
    }),
    
    ...((type === "download") && {
      href: linkUrl,
      target: "_blank",
    }),
    ...((arrow || animate) && {
      as: motion.a,
      whileHover: "hover",
    }),
    ...restLinkStyles,
  };

  const InnerLink = (
    <ChakraLink
      variant={variant}
      color={color}
      {...(variant === "pill" && {
        borderColor: color === "black" ? "#d9d9d9" : color,
      })}
      {...innerLinkProps}
      suppressHydrationWarning >
      {arrow ? (
        <LinkChildrenWithArrow arrowDir={arrowDir} color={color}>
          {children}
        </LinkChildrenWithArrow>
      ) : (
        children
      )}
    </ChakraLink>
  );

  if (["internal-other", "external", "download"].some((t) => t === type))
    return InnerLink;
  else return <RootLink href={linkUrl} >{InnerLink}</RootLink>;
}
