import { string, number, bool, object, func } from "prop-types";
import Image from "next/image";
import { shimmer, toBase64 } from "@/app/_utils";

export default function AppImage({
  src,
  alt,
  title,
  width = "",
  height = "",
  style = {},
  sizes = "",
  onLoad = () => {},
  blurDataURL = `data:image/svg+xml;base64,${toBase64(
    shimmer("100%", "100%")
  )}`,
  fill = false,
  priority = false,
}) {
  let imageProps = {
    src,
    alt,
    title,
    style,
    sizes,
    onLoad,
  };

  if (fill)
    imageProps = {
      ...imageProps,
      fill,
    };
  else
    imageProps = {
      ...imageProps,
      width,
      height,
    };

  return (
    <Image
      title={title}
      placeholder="blur"
      blurDataURL={blurDataURL}
      {...imageProps}
      priority={priority}
    />
  );
}

AppImage.propTypes = {
  src: string.isRequired,
  alt: string.isRequired,
  width: number,
  height: number,
  style: object,
  sizes: string,
  onLoad: func,
  fill: bool,
  priority: bool,
};
