import useKeypress from "react-use-keypress";
import { useSwipeable } from "react-swipeable";

import { useLightboxContext } from "@/app/_context";
import { useGallery } from "./_utils/useGallery";
import AppModal from "../AppModal";
import {
  Nav,
  GalleryMotionConfig,
  GalleryRootWrapper,
  GalleryItemWrapper,
  ComponentPresence,
  ImageItem,
  VideoItem,
  NavigationWrapper,
  ArrowNavigation,
  ThumbnailNavWrapper,
  ThumbnailNavigation,
} from "./_components";

export default function AppGalleryLightBox({ isOpen, onClose }) {
  const { activeKey, gallery, activeIndex } = useLightboxContext();
  const { handleChangeGalleryItem } = useGallery();

  const handlers = useSwipeable({
    onSwipedLeft: () => {
      if (activeIndex < gallery[activeKey].length - 1) {
        handleChangeGalleryItem(activeIndex + 1);
      }
    },
    onSwipedRight: () => {
      if (activeIndex > 0) {
        handleChangeGalleryItem(activeIndex - 1);
      }
    },
    trackMouse: true,
  });

  useKeypress("ArrowRight", () => {
    if (activeIndex + 1 < gallery[activeKey].length) {
      handleChangeGalleryItem(activeIndex + 1);
    }
  });

  useKeypress("ArrowLeft", () => {
    if (activeIndex > 0) {
      handleChangeGalleryItem(activeIndex - 1);
    }
  });

  return (
    <AppModal
      size="full"
      isOpen={isOpen}
      onClose={onClose}
      hasHeader
      renderHeader={() => <Nav />}
      modalProps={{
        bg: "blackAlpha.900",
        overflow: "hidden",
      }}
      modalHeaderProps={{
        borderBottom: "1px solid gray",
      }}
      closeBtnProps={{
        color: "white",
      }}
      modalBodyProps={{
        w: "full",
        display: "flex",
        alignItems: "center",
        overflow: "hidden",
        p: 0,
        ...handlers
      }}
    >
      <GalleryMotionConfig>
        <GalleryRootWrapper>
          <ComponentPresence custom>
            <GalleryItemWrapper>
              {activeKey === "images" ? <ImageItem /> : <VideoItem />}
            </GalleryItemWrapper>
          </ComponentPresence>
          <NavigationWrapper>
            <ArrowNavigation />
            <ThumbnailNavWrapper>
              <ComponentPresence>
                <ThumbnailNavigation />
              </ComponentPresence>
            </ThumbnailNavWrapper>
          </NavigationWrapper>
        </GalleryRootWrapper>
      </GalleryMotionConfig>
    </AppModal>
  );
}
