import { useCallback } from "react";
import { useLightboxContext, useDispatchContext } from "@/app/_context";

export function useGallery() {
  const dispatch = useDispatchContext();
  const { activeIndex } = useLightboxContext();

  const handleChangeGalleryItem = useCallback(
    (newIndex) => {
      if (newIndex > activeIndex) dispatch({ type: "SET_DIRECTION", value: 1 });
      else dispatch({ type: "SET_DIRECTION", value: -1 });

      dispatch({ type: "SET_ACTIVE_INDEX", value: newIndex });
    },
    [dispatch, activeIndex]
  );

  return {
    handleChangeGalleryItem,
  };
}
