import ReactPlayer from "react-player";
import { useLightboxContext } from "@/app/_context";

export default function VideoItem() {
  const { activeIndex, activeKey, gallery } = useLightboxContext();
  const { url } = gallery[activeKey][activeIndex];
  
  return (
    <ReactPlayer
      url={url}
      className="player"
      width="100%"
      height="100%"
      config={{
        youtube: {
          playerVars: { showinfo: 1, controls: 1, fs: 0 },
        },
        file: {
          attributes: {
            controls: true,
            disablePictureInPicture: true,
          },
          forceVideo: true
        }
      }}
    />
  );
}
