import { motion } from "framer-motion";
import { Box } from "@chakra-ui/react";

import { useLightboxContext } from "@/app/_context";
import { useGallery } from "../_utils/useGallery";

import AppImage from "../../AppImage";
import { range } from "../_utils";

function ThumbnailImage({ url, alt, base64 }) {
  return (
    <AppImage
      src={url}
      alt={alt}
      blurDataURL={base64}
      width={200}
      height={150}
      style={{
        height: "100%",
        width: "100%",
        objectFit: "cover",
      }}
    />
  );
}

export default function ThumbnailNavigation() {
  const { gallery, activeIndex, activeKey } = useLightboxContext();
  const { handleChangeGalleryItem } = useGallery();

  const filterGalleryItems = gallery[activeKey]?.filter((img) =>
    range(activeIndex - 15, activeIndex + 15).includes(img.idx)
  );

  return (
    <>
      {filterGalleryItems.map(({ id, idx, image, ...restProps }) => (
        <Box
          key={id}
          pos="relative"
          display="inline-block"
          w="full"
          flexShrink={0}
          as={motion.button}
          cursor="pointer"
          initial={{
            width: "0%",
            x: `${Math.max((activeIndex - 1) * -100, 15 * -100)}%`,
          }}
          animate={{
            scale: idx === activeIndex ? 1.25 : 1,
            width: "100%",
            x: `${Math.max(activeIndex * -100, 15 * -100)}%`,
          }}
          sx={{
            "> img": {
              ...(activeIndex === idx
                ? {
                    borderRadius: "md",
                    filter: "auto",
                    brightness: "100%",
                  }
                : {
                    filter: "auto",
                    brightness: "50%",
                    contrast: "125%",
                    _hover: {
                      brightness: "75%",
                    },
                    transition: "all linear 150ms",
                  }),
              ...(idx === 0 && {
                borderTopLeftRadius: "md",
                borderBottomLeftRadius: "md",
              }),
              ...(idx === gallery[activeKey].length - 1 && {
                borderTopRightRadius: "md",
                borderBottomRightRadius: "md",
              }),
            },
          }}
          {...(activeIndex === idx && {
            zIndex: 20,
          })}
          onClick={() => handleChangeGalleryItem(idx)}
          exit={{ width: "0%" }}
        >
          <ThumbnailImage {...image} />
        </Box>
      ))}
    </>
  );
}
