import { useCallback } from "react";
import { List, ListItem } from "@chakra-ui/react";
import { useLightboxContext, useDispatchContext } from "@/app/_context";

export default function Nav() {
  const dispatch = useDispatchContext();
  const { navKeys, activeKey } = useLightboxContext();

  const handleChangeNav = useCallback(
    (navKey) => {
      dispatch({ type: "SET_ACTIVE_KEY", value: navKey });
      dispatch({ type: "SET_ACTIVE_INDEX", value: 0 });
    },
    [dispatch]
  );

  return (
    <List display="inline-flex" gap={5} color="white">
      {navKeys.map((item) => (
        <ListItem
          key={item}
          color={activeKey === item ? "white" : "gray.300"}
          fontSize="15px"
          cursor="pointer"
          _hover={{
            color: "white",
          }}
          onClick={() => handleChangeNav(item)}
        >
          {item === "images" ? "Images" : "Videos"}
        </ListItem>
      ))}
    </List>
  );
}
