import { Box, Text, IconButton } from "@chakra-ui/react";
import { BsDownload } from "react-icons/bs";

import { useLightboxContext } from "@/app/_context";

import AppImage from "../../AppImage";
import { forceDownload } from "../_utils";

export default function ImageItem() {
  const { gallery, activeKey, activeIndex } = useLightboxContext();
  const {
    caption,
    image: { url, alt, base64 },
  } = gallery[activeKey][activeIndex];

  return (
    <Box pos="relative" h="full" w="full">
      <AppImage
        src={url}
        alt={alt}
        blurDataURL={base64}
        width={1280}
        height={853}
        style={{ width: "auto" }}
        priority
      />
      <Box
        pos="absolute"
        insetX={0}
        top={{
          base: "unset",
          md: 0,
        }}
        p={{
          base: 2,
          md: 4,
        }}
        blur="5px"
        bg="blackAlpha.400"
      >
        <Text color="white">{caption}</Text>
      </Box>
      
      <Box pos="absolute" right={0} p={2} top={0}>
      <IconButton
  icon={<BsDownload />}
  onClick={() => {
    const downloadFile = () => {
      // Create a new XMLHttpRequest to fetch the file
      const xhr = new XMLHttpRequest();
      xhr.open("GET", url, true);
      xhr.responseType = "blob"; // important
      xhr.onload = function() {
        const blob = xhr.response;

        // Create a new anchor element
        const downloadLink = document.createElement("a");
        downloadLink.href = window.URL.createObjectURL(blob);

        // Set the filename for the downloaded file
        downloadLink.download = alt;

        // Optionally set the 'force download' attribute
        //if (forceDownload) {
          downloadLink.setAttribute("download", alt);
        //}

        // Append the anchor element to the body and trigger a click
        document.body.appendChild(downloadLink);
        downloadLink.click();

        // Cleanup: Remove the anchor element after the download
        setTimeout(() => {
          document.body.removeChild(downloadLink);
          window.URL.revokeObjectURL(downloadLink.href);
        }, 100);
      };
      xhr.send();
    };

    downloadFile();
  }}
  size="md"
  isRound={true}
  bg="orangePeel.900"
/>

      </Box>
    </Box>
  );
}
