import { node, bool } from "prop-types";
import { MotionConfig, AnimatePresence } from "framer-motion";
import { Box } from "@chakra-ui/react";

import { useLightboxContext } from "@/app/_context";

import { AnimationWrapper } from "../../AnimationWrapper";
import { variants } from "../_utils";

export function GalleryMotionConfig({ children }) {
  return (
    <MotionConfig
      transition={{
        x: { type: "spring", stiffness: 300, damping: 30 },
        opacity: { duration: 0.2 },
      }}
    >
      {children}
    </MotionConfig>
  );
}

GalleryMotionConfig.propTypes = {
  children: node.isRequired,
};

export function ComponentPresence({ children, custom = false }) {
  const { direction } = useLightboxContext();

  return (
    <AnimatePresence
      initial={false}
      {...(custom && {
        custom: direction,
      })}
    >
      {children}
    </AnimatePresence>
  );
}

ComponentPresence.propTypes = {
  children: node.isRequired,
  custom: bool,
};

export function GalleryRootWrapper({ children }) {
  return (
    <Box
      pos="relative"
      display="flex"
      justifyContent="center"
      alignItems="center"
      maxW="7xl"
      w="full"
      mx="auto"
      zIndex={50}
    >
      {children}
    </Box>
  );
}

GalleryRootWrapper.propTypes = {
  children: node.isRequired,
};

export function GalleryItemWrapper({ children }) {
  const { activeKey, activeIndex, direction } = useLightboxContext();

  return (
    <AnimationWrapper
      custom={direction}
      variants={variants}
      key={activeIndex}
      pos="absolute"
      initial="enter"
      animate="center"
      exit="exit"
      {...(activeKey === "videos" && {
        pt: "56.25%",
        w: "full",
        sx: {
          ".player": {
            pos: "absolute",
            top: 0,
            left: 0,
          },
        },
      })}
      overflow={false}
    >
      {children}
    </AnimationWrapper>
  );
}

GalleryItemWrapper.propTypes = {
  children: node.isRequired,
};

export function NavigationWrapper({ children }) {
  return (
    <Box
      pos="absolute"
      inset={0}
      mx="auto"
      display="flex"
      justifyContent="center"
      alignItems="center"
      maxW="7xl"
    >
      {children}
    </Box>
  );
}

NavigationWrapper.propTypes = {
  children: node.isRequired,
};

export function ThumbnailNavWrapper({ children }) {
  return (
    <Box pos="fixed" insetX={0} bottom={0} overflow="hidden">
      <AnimationWrapper
        initial={false}
        mx="auto"
        display="flex"
        aspectRatio=" 3 / 2"
        mt={6}
        mb={6}
        h={14}
        overflow={false}
      >
        { children }
      </AnimationWrapper>
    </Box>
  );
}

ThumbnailNavWrapper.propTypes = {
  children: node.isRequired,
};
