import { Box, IconButton } from "@chakra-ui/react";
import { BsArrowLeft, BsArrowRight } from "react-icons/bs";

import { useLightboxContext } from "@/app/_context";
import { useGallery } from "../_utils/useGallery";

export default function ArrowNavigation() {
  const { activeIndex, gallery, activeKey } = useLightboxContext();
  const { handleChangeGalleryItem } = useGallery();

  return (
    <Box pos="relative" maxH="full" w="full">
      {activeIndex > 0 && (
        <IconButton
          onClick={() => handleChangeGalleryItem(activeIndex - 1)}
          icon={<BsArrowLeft />}
          size="md"
          pos="absolute"
          left={{
            base: 4,
            xl: -12,
          }}
          top={-4}
          isRound={true}
          bg="orangePeel.900"
        />
      )}

      {activeIndex + 1 < gallery[activeKey].length && (
        <IconButton
          icon={<BsArrowRight />}
          onClick={() => handleChangeGalleryItem(activeIndex + 1)}
          size="md"
          pos="absolute"
          right={{
            base: 4,
            xl: -12,
          }}
          top={-4}
          isRound={true}
          bg="orangePeel.900"
        />
      )}
    </Box>
  );
}
