import dynamic from "next/dynamic";
import { forwardRef } from "react";
import { Input } from "@chakra-ui/react";
import { getDay } from "date-fns";

const ReactDatePicker = dynamic(() =>
  import("react-datepicker").then((mod) => mod.default)
);

const DatePickerCustomInput = forwardRef((props, ref) => (
  <Input
    variant="outline"
    borderRadius="full"
    borderColor="orangePeel.900"
    focusBorderColor="orangePeel.900"
    _hover={{
      borderColor: "orangePeel.900",
    }}
    ref={ref}
    {...props}
  />
));

DatePickerCustomInput.displayName = "DatepickerInput";

export default function AppDatepicker({ customInput = false, ...restProps }) {
  if (customInput) {
    return (
      <ReactDatePicker
        customInput={<DatePickerCustomInput />}
        dayClassName={(date) =>
          [0, 6].includes(getDay(date))
            ? "react-datepicker__day--holiday"
            : undefined
        }
        onFocus={() => {}}
        popperClassName="react-datepicker__default"
        {...restProps}
      />
    );
  } else {
    return (
      <ReactDatePicker
        dayClassName={(date) =>
          [0, 6].includes(getDay(date))
            ? "react-datepicker__day--holiday"
            : undefined
        }
        onClickOutside={() => {}}
        {...restProps}
      />
    );
  }
}
