import { useCallback, useEffect, useState } from "react";
import { IconButton } from "@chakra-ui/react";
import { motion } from "framer-motion";
import { SvgArrow } from "../Svg";

export const usePrevNextButtons = (emblaApi) => {
  const [prevBtnDisabled, setPrevBtnDisabled] = useState(true);
  const [nextBtnDisabled, setNextBtnDisabled] = useState(true);

  const onPrevButtonClick = useCallback(() => {
    if (!emblaApi) return;
    emblaApi.scrollPrev();
  }, [emblaApi]);

  const onNextButtonClick = useCallback(() => {
    if (!emblaApi) return;
    emblaApi.scrollNext();
  }, [emblaApi]);

  const onSelect = useCallback((emblaApi) => {
    setPrevBtnDisabled(!emblaApi.canScrollPrev());
    setNextBtnDisabled(!emblaApi.canScrollNext());
  }, []);

  useEffect(() => {
    if (!emblaApi) return;

    onSelect(emblaApi);
    emblaApi.on("reInit", onSelect);
    emblaApi.on("select", onSelect);
  }, [emblaApi, onSelect]);

  return {
    prevBtnDisabled,
    nextBtnDisabled,
    onPrevButtonClick,
    onNextButtonClick,
  };
};

export const SliderButton = (props) => {
  const { direction, color, disabled, ...restProps } = props;

  return (
    <IconButton
      isRound
      bg="transparent"
      aria-label={
        direction === "ltr" ? "Go to next slider" : "Back to previous Slider"
      }
      variant="outline"
      size="lg"
      color="white"
      borderColor="orangePeel.900"
      sx={{
        _hover: {
          "& > svg path": {
            fill: "orangePeel.900",
          },
        },
      }}
      icon={<SvgArrow variant="large" color={color} direction={direction} />}
      as={motion.button}
      whileHover={disabled ? "none" : "hover"}
      disabled={disabled}
      {...restProps}
    />
  );
};
