import { ReactSVG } from "react-svg";
import { Box, Flex, Text, Heading } from "@chakra-ui/react";
import { Card, AppLink } from "..";

export default function InfoCard({
  heading,
  description,
  contact_no,
  link: { text, ...restLinkProps },
}) {
  return (
    <Card>
      <Flex direction="column" gap={5}>
        <Heading as="h6" fontSize="24px" color="black">
          {heading}
        </Heading>
        <Text as="p">{description}</Text>
        <Flex gap={5}>
          <ReactSVG src="/icons/contact.svg" />
          <Text as="span">{contact_no}</Text>
        </Flex>
        <Flex justify="space-between">
          <Box display="inline-flex">
            <AppLink {...restLinkProps} variant="pill" color="black" arrow>
              {text}
            </AppLink>
          </Box>
        </Flex>
      </Flex>
    </Card>
  );
}
