import { oneOf, node } from "prop-types";
import { Button } from "@chakra-ui/react";

export default function AppButton({
  children,
  variant = "white",
  onClick = () => {},
}) {
  let btnStyle = {
    borderRadius: "full",
    py: 6,
    display: "flex",
    alignItems: "center",
    fontWeight: "medium",
    fontSize: "18px",
    gap: 4,
    w: "full",
  };

  if (variant === "white") {
    btnStyle = {
      ...btnStyle,
      transition:".3s ease-in-out",
      color: "white",
      backgroundColor: "orangePeel.900",
      border: "1px",
      _hover: {
        backgroundColor: "white",
        color: "black",
        borderColor: "orangePeel.900"
      }
    };
  } else if (variant === "black" || variant === "none") {
    btnStyle = {
      ...btnStyle,
      color: "black",
      borderColor: "orangePeel.900",
      borderWidth: "1px",
      bg: "transparent",
      _hover: {
        bg: "transparent",
      },
      ...(variant === "none" && {
        borderRadius: "none",
        py: 0,
        border: "none",
      }),
    };
  }

  return (
    <Button
      {...btnStyle}
      display="flex"
      gap={4}
      alignItems="center"
      onClick={() => onClick()}
    >
      {children}
    </Button>
  );
}

AppButton.propTypes = {
  children: node.isRequired,
  variant: oneOf(["white", "black", "none"]),
};
