import Link from "next/link";
import { Box, Spacer, Link as ChakraLink } from "@chakra-ui/react";

import { motion } from "framer-motion";

import { SvgArrow } from "../SvgNew";

const RootLink = ({ children, href }) => {
  return (
    <Link href={href} passHref legacyBehavior>
      {children}
    </Link>
  );
};
const LinkChildrenWithArrow = ({ children, arrowDir, color, hoverColor  }) => {
  return (
    <Box display="flex" alignItems="center">
      {arrowDir === "rtl" && (
        <>
          <SvgArrow direction={arrowDir} color={color} hoverColor={hoverColor} />
          <Spacer mr={2} /> {/* Adjust mr (margin-right) for spacing */}
        </>
      )}
      <Box flexGrow={1}>{children}</Box>
      {arrowDir === "ltr" && (
        <>
          <Spacer ml={2} /> {/* Adjust ml (margin-left) for spacing */}
          <SvgArrow direction={arrowDir} color={color} hoverColor={hoverColor} />
        </>
      )}
    </Box>
  );
};

export default function AppBox({
  variant = "default",
  color = "white",
  arrowDir = "ltr",
  arrow = false,
  animate = false,
  title,
  type,
  parent,
  slug = "",
  children,
  boxSize=false,
  ...restLinkStyles
  
}) {
  let prnt;
  type === "internal"
      ? prnt=process.env.NEXT_PUBLIC_APP_BASE_URL + parent 
      : type === "internal-other"
      ? prnt=process.env.NEXT_PUBLIC_OLD_URL + parent 
      : prnt=parent 
  const linkUrl = (prnt ?? "").concat(slug ?? "");

  const innerLinkProps = {
    title,
    ...((type === "internal-other" || type === "external" || type === "internal") && {
      href: linkUrl,
    }),
    ...((type === "external" || type === "internal-other" )&& {
      target: "_blank",
      rel: "noopener noreferrer",
    }),
    
    ...((type === "download") && {
      href: linkUrl,
      target: "_blank",
    }),
    ...((arrow || animate) && {
      as: motion.a,
      whileHover: "hover",
    }),
    ...restLinkStyles,
  };
  const InnerLink = (
    <Box as={motion.button}
    whileHover="hover"
    borderRadius="full"
    bg="transparent"
    borderColor={color}
    borderWidth="1px"
    color={color}
    px={4}
    h={8}
    display="flex"
    alignItems="center" 
    _hover={{ borderColor:'orange' }}
    >
  {arrow ? (
        <LinkChildrenWithArrow arrowDir={arrowDir} color={color} hoverColor="orange">
          {children}
        </LinkChildrenWithArrow>
      ) : (
        children
      )}
</Box>
  );
 if (["internal-other", "external", "download"].some((t) => t === type))
    return InnerLink;
  else return <RootLink href={linkUrl}>{InnerLink}</RootLink>;
  
}
