import { node, bool, oneOf } from "prop-types";
import { motion } from "framer-motion";
import { Box } from "@chakra-ui/react";

export function AnimationWrapper({
  children,
  animateRoot = false,
  overlay = false,
  whileHover = false,
  overflow = true,
  overlayType = "dark",
  ...restWrapperStyleProps
}) {
  let rootWrapperProps = {
    as: motion.div,
    ...(animateRoot && {
      pos: "relative",
      initial: false,
    }),
    ...(overflow && {
      overflow: "hidden",
    }),
    ...(whileHover && {
      whileHover: "hover",
    }),
    ...(overlay && {
      _before: {
        content: "''",
        pos: "absolute",
        top: 0,
        left: 0,
        bottom: 0,
        zIndex: 1,
        w: "full",
        h: "full",
        bgGradient:
          overlayType === "dark"
            ? "linear(to-b, transparent 70%, rgba(0, 0, 0, 0.7) 100%)"
            : "linear(to-b, transparent 70%, rgba(0, 0, 0, 0.7) 100%)",
      },
    }),
    ...restWrapperStyleProps,
  };

  return <Box {...rootWrapperProps}>{children}</Box>;
}

AnimationWrapper.propTypes = {
  children: node.isRequired,
  animateRoot: bool,
  whileHover: bool,
  layout: bool,
  overlay: bool,
  overflow: bool,
  overlayType: oneOf(["dark", "light"]),
};
